unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, PSServerProj1_TLB, StdCtrls, ComCtrls, Spin, ExtCtrls;
type
  TCommBuf = array[0..25] of Byte;
  TFormMain = class(TForm)
    btnOpen: TButton;
    btnClose: TButton;
    EditPort: TEdit;
    StatusBar1: TStatusBar;
    btnRead: TButton;
    btnControl: TButton;
    btnSetting: TButton;
    Memo1: TMemo;
    EditAdd: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    cbPc: TCheckBox;
    cbOn: TCheckBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    seVolMax: TSpinEdit;
    seCurMax: TSpinEdit;
    sePow: TSpinEdit;
    seVol: TSpinEdit;
    Bevel1: TBevel;
    cbBaud: TComboBox;
    Bevel2: TBevel;
    Bevel3: TBevel;
    PSServer1: TPSServer;
    Button1: TButton;
    procedure btnOpenClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure btnReadClick(Sender: TObject);
    procedure btnControlClick(Sender: TObject);
    procedure btnSettingClick(Sender: TObject);
    procedure EditAddKeyPress(Sender: TObject; var Key: Char);
    procedure PSServer1Receive(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    ReceBuf:TCommBuf;
    SendBuf:TCommBuf;
    H:Longint;
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

//Open Com
procedure TFormMain.btnOpenClick(Sender: TObject);
var
  Flag:Boolean;
begin
  //Open COM
  PSServer1.PS_OpenComm(StrToInt(EditPort.Text),StrToInt(cbBaud.Text),8,0,0);
  //Setting Device Address
  PSServer1.PS_SetDeviceAdd(StrToInt(EditAdd.Text));
  //Get Execute Result
  if PSServer1.PS_GetExecResult >0 then
    Flag:=True
  else
    Flag:=False;
  btnClose.Enabled:=Flag;
  btnRead.Enabled:=Flag;
  btnControl.Enabled:=Flag;
  btnSetting.Enabled:=Flag;
end;

//Close COM
procedure TFormMain.btnCloseClick(Sender: TObject);
begin
  PSServer1.PS_CloseComm;
  btnClose.Enabled:=False;
  btnRead.Enabled:=False;
  btnControl.Enabled:=False;
  btnSetting.Enabled:=False;
end;

//Read Power Params
procedure TFormMain.btnReadClick(Sender: TObject);
begin
  PsServer1.PS_ReadParams;
end;

//Control Power State
procedure TFormMain.btnControlClick(Sender: TObject);
var
  State:Byte;
begin
  State:=0;
  if cbPc.Checked then
  begin
   if cbOn.Checked then
     State:=3
   else
     State:=2;
  end;
  PsServer1.PS_ControlState(State);
end;

//Setting Power Params
procedure TFormMain.btnSettingClick(Sender: TObject);
var
  Cur,Vol,VolMax,Pow:longint;
begin
  Cur:=seCurMax.Value*1000;
  VolMax:=seVolMax.Value*1000;
  Pow:=sePow.Value*100;
  Vol:=seVol.Value*1000;
  PsServer1.PS_SetParams(Cur,VolMax,Pow,Vol,StrToInt(EditAdd.Text))
end;

procedure TFormMain.EditAddKeyPress(Sender: TObject; var Key: Char);
begin
  if not (key in['0'..'9']) then
    Key:=#0;
end;

//Receive Data Event
procedure TFormMain.PSServer1Receive(Sender: TObject);
var
  Str1:String;
  CurValue,VolValue,PowValue,
  CurMax,VolMax,PowMax,VolSetting,State:Integer;
begin
  State:=0;
  psServer1.PS_GetData(CurValue,CurMax,VolValue,VolSetting,
                       VolMax, PowValue, PowMax,State);
  Memo1.Lines.Add('---------------- Read Params ---------------');
  Str1:=Format('CurValue : %dmA VolValue : %dmV PowValue %dW',[CurValue,VolValue,PowValue div 100]);
  Memo1.Lines.Add(Str1);
  Str1:=Format('CurMax : %dmA VolMax : %dmV PowMax %dW',[CurMax,VolMax,PowMax div 100]);
  Memo1.Lines.Add(Str1);
  Str1:=Format('VolSetting : %dmV State : %d ',[VolSetting,State]);
  Memo1.Lines.Add(Str1);
  if State and 1 >0 then
    Str1:='Output State : On'
  else
    Str1:='Output State : Off';
  Memo1.Lines.Add(Str1);
  if State and 2 = 0 then
    Str1:='Current State : Normal'
  else
    Str1:='Current State : No Normal';
  Memo1.Lines.Add(Str1);
  if State and 4 = 0 then
    Str1:='Power State : Normal'
  else
    Str1:='Power State : No Normal';
  Memo1.Lines.Add(Str1);
  if State and 8 = 0 then
    Str1:='Control State : By Self'
  else
    Str1:='Control State : By PC';
  Memo1.Lines.Add(Str1);
end;

procedure TFormMain.Button1Click(Sender: TObject);
begin
  PSServer1.PS_ShowAbout;
end;

end.
